/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.gpio;

import android.content.Context;
import android.hardware.gpio.GpioPort;
import android.hardware.gpio.IGpioManager;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class GpioManager {
    private static final String TAG = "GpioManager";
    private final Context mContext;
    private final IGpioManager mService;

    public GpioManager(Context context, IGpioManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public String[] getSupportedGpioPorts() {
        try {
            return this.mService.getSupportedGpioPorts();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException in getSupportedGpioPorts", (Throwable)e);
            return null;
        }
    }

    public int getGpioValue(String name) {
        try {
            return this.mService.getGpioValue(name);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"RemoteException in getGpioValue", (Throwable)e);
            return -1;
        }
    }

    public GpioPort obtainGpioPortControl(String name) throws IOException {
        try {
            if (this.mService.obtainGpioPortControl(name)) {
                GpioPort port = new GpioPort();
                port.gpio_init();
                return port;
            }
            throw new IOException("Could not open gpio port " + name);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"exception in UsbManager.openDevice", (Throwable)e);
            return null;
        }
    }
}

