/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans;

import com.rfid.serialport.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public class MessageTran {
    private InputStream mInStream = null;
    private OutputStream mOutStream = null;
    private SerialPort mSerialPort = null;
    private boolean connected = false;

    public boolean isOpen() {
        return this.connected;
    }

    public int open(String ComPort, int BaudRate) {
        try {
            this.mSerialPort = new SerialPort(new File(ComPort), BaudRate, 0);
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
        if (this.mSerialPort != null) {
            this.mInStream = this.mSerialPort.getInputStream();
            this.mOutStream = this.mSerialPort.getOutputStream();
            this.connected = true;
            return 0;
        }
        return -1;
    }

    public int close() {
        if (this.mInStream != null) {
            try {
                this.mInStream.close();
                this.mOutStream.close();
                this.mSerialPort.close();
                this.mSerialPort = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.connected = false;
        return 0;
    }

    public byte[] Read() {
        if (!this.connected) {
            return null;
        }
        try {
            byte[] RecvBuff;
            int len;
            int count = this.mInStream.available();
            if (count > 0 && (len = this.mInStream.read(RecvBuff = new byte[count])) > 0) {
                byte[] buff = new byte[len];
                System.arraycopy(RecvBuff, 0, buff, 0, len);
                return buff;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int Write(byte[] buffer) {
        if (!this.connected) {
            return -1;
        }
        if (buffer.length != (buffer[0] & 0xFF) + 1) {
            return -1;
        }
        try {
            byte[] cmd = new byte[(buffer[0] & 0xFF) + 1];
            System.arraycopy(buffer, 0, cmd, 0, cmd.length);
            this.mOutStream.write(cmd);
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

