package com.uhf.setting;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Spinner;

import com.uhf.event.BaseFragment;
import com.uhf.uhfdemo.MyApp;
import com.uhf.uhfdemo.R;
import com.uhf.util.MUtil;

import static android.text.TextUtils.isEmpty;

public class KillTagFragment extends BaseFragment implements View.OnClickListener {

    private Spinner spFilterMbKill;
    private EditText EtFilterAdsKill, EtFilterLenKill, EtFilterDataKill;
    private EditText EtAcPwdKill;

    private View v;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return v = inflater.inflate(R.layout.fragment_kill_tag, container, false);
    }

    @Override
    public void onResume() {
        super.onResume();
        spFilterMbKill = v.findViewById(R.id.spinner_MB);

        EtFilterAdsKill = v.findViewById(R.id.Et_set_ads);
        EtFilterLenKill = v.findViewById(R.id.Et_Set_len);
        EtFilterDataKill = v.findViewById(R.id.Et_Set_data);

        EtAcPwdKill = v.findViewById(R.id.Et_AcPwdKill);
        v.findViewById(R.id.Bt_Kill).setOnClickListener(this);

        EtFilterDataKill.setText("1234567890ABCDEF12345678");
        EtAcPwdKill.setText("00000000");
        EtFilterAdsKill.setText("32");
        EtFilterLenKill.setText("96");
    }


    @Override
    public void onClick(View v) {
        if (ifNotNull()) {
            int ads = Integer.valueOf(EtFilterAdsKill.getText().toString());
            int len = Integer.valueOf(EtFilterLenKill.getText().toString());
            int val = spFilterMbKill.getSelectedItemPosition();
            //标签销毁操作
            // Destroy labels
            boolean status = MyApp.getMyApp().getUhfMangerImpl().killTag(EtAcPwdKill.getText().toString(), MyApp.UHF[val],
                    ads, len, EtFilterDataKill.getText().toString());  
            int result = status ? R.string.kill_tag_success : R.string.kill_tag_failed;
            MUtil.show(result);
        } else {
            MUtil.show(R.string.data_notnull);
        }
    }

    //如果EditText的数据都不为空
    // If all the EditText data is not null
    private boolean ifNotNull() {
        return !isEmpty(EtFilterDataKill.getText()) && !isEmpty(EtFilterAdsKill.getText())
                && !isEmpty(EtFilterLenKill.getText()) && !isEmpty(EtAcPwdKill.getText());
    }
}
