package com.uhf.setting;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import com.uhf.event.BaseFragment;
import com.uhf.uhfdemo.MyApp;
import com.uhf.uhfdemo.R;
import com.uhf.util.MLog;
import com.uhf.util.MUtil;
import com.uhf.base.UHFManager;
import com.uhf.base.UHFModuleType;

import java.util.HashSet;
import java.util.Objects;

import static com.uhf.uhfdemo.MyApp.ifSupportR2000Fun;

/**
 * author CYD
 * date 2018/11/22
 * email cyd19950902@qq.com
 */
public class PoweFrequencyFragment extends BaseFragment implements View.OnClickListener {

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.port_adress_setting, container, false);
    }

    private Spinner powerGet, area_frequency, sesionMode, invMode;

    private EditText inventory_time, sleep_time;
    private CheckBox poweroff_save, save_inv_mode;

    private TextView showNeedList;

    private int[] cn_920 = {922375, 921125, 924125, 920875, 921875, 921375, 923875, 922625, 923125, 924375, 922125, 923375, 920625, 921625, 923625, 922875};
    private int[] cn_840 = {842375, 841125, 844125, 840875, 841875, 841375, 843875, 842625, 843125, 844375, 842125, 843375, 840625, 841625, 843625, 842875};
    private int[] eu = {867500, 866300, 865700, 866900};
    private int[] us = {915750, 927250, 902750, 915250, 903250, 926750, 910750, 922750, 906750, 926250, 904250, 920250, 919250, 909250, 918750, 917750,
            905250, 904750, 925250, 921750, 914750, 913750, 922250, 911250, 911750, 903750, 908750, 905750, 912250, 906250, 917250, 914250, 907250, 918250,
            916250, 910250, 907750, 924750, 909750, 919750, 916750, 913250, 923750, 908250, 925750, 912750, 924250, 921250, 920750, 923250};

    private boolean ifJ06;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        showNeedList = view.findViewById(R.id.showNeedList);
        powerGet = view.findViewById(R.id.powerGet);
        area_frequency = view.findViewById(R.id.area_frequency);
        sesionMode = view.findViewById(R.id.sesionMode);
        invMode = view.findViewById(R.id.invMode);
        save_inv_mode = view.findViewById(R.id.save_inv_mode);
        ((CheckBox) view.findViewById(R.id.soundSwitch)).setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                MyApp.ifOpenSound = isChecked;
            }
        });

        view.findViewById(R.id.setPower).setOnClickListener(this);
        view.findViewById(R.id.getPower).setOnClickListener(this);
        view.findViewById(R.id.set_area_frequency).setOnClickListener(this);
        view.findViewById(R.id.get_area_frequency).setOnClickListener(this);
        LinearLayout session_setting_title = view.findViewById(R.id.session_setting_title);
        Button setSessionMode = view.findViewById(R.id.set_session_mode);
        setSessionMode.setOnClickListener(this);
        Button getSessionMode = view.findViewById(R.id.get_session_mode);
        getSessionMode.setOnClickListener(this);
        view.findViewById(R.id.set_frq_rang).setOnClickListener(this);
        view.findViewById(R.id.get_frq_rang).setOnClickListener(this);
        Button set_inv_mode = view.findViewById(R.id.set_inv_mode);
        set_inv_mode.setOnClickListener(this);
        Button get_inv_mode = view.findViewById(R.id.get_inv_mode);
        get_inv_mode.setOnClickListener(this);

        inventory_time = view.findViewById(R.id.inventory_time);
        sleep_time = view.findViewById(R.id.sleep_time);
        poweroff_save = view.findViewById(R.id.poweroff_save);
        view.findViewById(R.id.set_inventory_time).setOnClickListener(this);
        view.findViewById(R.id.get_inventory_time).setOnClickListener(this);

        //判断是否为小i设备
        // Determine if it is an i-series
        ifJ06 = MyApp.getMyApp().getUhfMangerImpl().ifJ06();

        //判断是否为UM7模块
        // Determine if it is a UM7 module
        if (!ifSupportR2000Fun) {
            area_frequency.setAdapter(new ArrayAdapter<>(Objects.requireNonNull(getActivity()),
                    android.R.layout.simple_spinner_item, getResources().getStringArray(R.array.frequency_only_cn2_usa)));
            invMode.setAdapter(new ArrayAdapter<>(getActivity(),
                    android.R.layout.simple_spinner_item, getResources().getStringArray(R.array.invMode_only_fast_auto)));
            getSessionMode.setVisibility(View.GONE);
            setSessionMode.setVisibility(View.GONE);
            session_setting_title.setVisibility(View.GONE);
        }
        if (UHFModuleType.SLR_MODULE == UHFManager.getType()) {
            view.findViewById(R.id.frq_param).setVisibility(View.GONE);
            ((View) invMode.getParent()).setVisibility(View.GONE);
            save_inv_mode.setVisibility(View.GONE);
            set_inv_mode.setVisibility(View.GONE);
            get_inv_mode.setVisibility(View.GONE);
        }
        Integer[] powerData;
        if (MyApp.if5100Module) {
            view.findViewById(R.id.sleep_time_layout).setVisibility(View.GONE);
            view.findViewById(R.id.session_fun_layout).setVisibility(View.GONE);
            powerData = new Integer[26];
            for (int i = 5; i <= 30; i++) {
                powerData[i - 5] = i;
            }
        } else {
            int size = ifJ06 ? 11 : (ifSupportR2000Fun ? 26 + 3 : 26);
            view.findViewById(R.id.um7ExtraFun).setVisibility(ifJ06 ? View.GONE : View.VISIBLE);
            powerData = new Integer[size];
            if (ifSupportR2000Fun) {
                for (int i = 5; i <= 30 + 3; i++) {
                    powerData[i - 5] = i;
                }
            } else if (ifJ06) {
                for (int i = 0; i <= 10; i++) {
                    powerData[i] = i;
                }
            } else {
                for (int i = 0; i <= 25; i++) {
                    powerData[i] = i;
                }
            }
        }
        ArrayAdapter adapter = new ArrayAdapter(getActivity(), android.R.layout.simple_spinner_item, powerData);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        powerGet.setAdapter(adapter);
    }

    //获取功率
    // Get power
    private boolean initPower() {
        int power = MyApp.getMyApp().getUhfMangerImpl().powerGet();
        if (power < 0 || power > 30 + 3) {
            return false;
        }
        if (ifSupportR2000Fun) {
            if (power >= 5) {
                powerGet.setSelection(power - 5);
                MLog.e("power = " + power);
                return true;
            }
        } else if (ifJ06) {
            powerGet.setSelection(power);
            return true;
        } else {
            if (power > 25)
                power = 25;
            powerGet.setSelection(power);
            return true;
        }
        return false;
    }

    //获取区域频率
    // Get area frequency
    private boolean getAreaFrequency() {
        int area_fq = MyApp.getMyApp().getUhfMangerImpl().frequencyModeGetNotFixedFreq();
        MLog.e("area_fq = " + area_fq);
        if (ifSupportR2000Fun) {
            area_frequency.setSelection(area_fq);
        } else {
            switch (area_fq) {
                case 1:
                    area_frequency.setSelection(0);
                    break;
                case 3:
                    area_frequency.setSelection(1);
                    break;
                case 5:
                    area_frequency.setSelection(2);
                    break;
                default:
                    return false;
            }
        }
/*        boolean areaFQFlag = area_fq >= 0 && area_fq <= 3;
        if (areaFQFlag) {
            if (ifSupportR2000Fun) {
                area_frequency.setSelection(area_fq);
            } else {
                area_frequency.setSelection(area_fq == 1 ? 0 : 1);
            }
        }*/
        return true;
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            // 设置功率
            // set power
            case R.id.setPower:
                int value = (int) powerGet.getSelectedItem();
                MLog.e("value = " + value);
                boolean ifValue = MyApp.getMyApp().getUhfMangerImpl().powerSet(value);
                setResult(ifValue);
                break;
            case R.id.getPower:
                setResult(initPower());
                break;
            //设置区域频率
            // set area frequency
            case R.id.set_area_frequency:
                int postion = 0;
                if (ifSupportR2000Fun) {
                    postion = area_frequency.getSelectedItemPosition();
                } else {
                    postion = area_frequency.getSelectedItemPosition();
                    switch (postion) {
                        case 0:
                            postion = 1;
                            break;
                        case 1:
                            postion = 3;
                            break;
                        case 2:
                            postion = 5;
                            break;
                        default:
                            break;
                    }
                }
                MLog.e("postion = " + postion);
                boolean ifSetAreaFQ = MyApp.getMyApp().getUhfMangerImpl().frequencyModeSet(postion);
                setResult(ifSetAreaFQ);
                break;
            case R.id.get_area_frequency:
                setResult(getAreaFrequency());
                break;
            case R.id.set_session_mode:
                int vals = sesionMode.getSelectedItemPosition();
                setResult(MyApp.getMyApp().getUhfMangerImpl().sessionModeSet(vals));
                break;
            case R.id.get_session_mode:
                //session模式
                //session mode
                int sMode = MyApp.getMyApp().getUhfMangerImpl().sessionModeGet();
                boolean modeGetFlag = sMode > -1 && sMode < 4;
                if (modeGetFlag) {
                    sesionMode.setSelection(sMode);
                }
                System.currentTimeMillis();
                setResult(modeGetFlag);
                break;
            case R.id.set_inventory_time:
                String iTime = inventory_time.getText().toString();
                String sTime = sleep_time.getText().toString();
                if (TextUtils.isEmpty(iTime) || TextUtils.isEmpty(sTime)) {
                    MUtil.show(R.string.time_empty_notice);
                } else {
                    boolean ifCheck = poweroff_save.isChecked();
                    boolean flag = MyApp.getMyApp().getUhfMangerImpl().inventoryWaitTime_Set(Integer.parseInt(iTime), Integer.parseInt(sTime), ifCheck);
                    setResult(flag);
                }
                break;
            case R.id.get_inventory_time:
                int[] times = MyApp.getMyApp().getUhfMangerImpl().inventoryWaitTime_Get();
                if (times == null) {
                    setResult(false);
                } else {
                    inventory_time.setText(times[0] + "");
                    sleep_time.setText(times[1] + "");
                }
                break;
            case R.id.set_frq_rang:
                selectFrq();
                break;
            case R.id.get_frq_rang:
                showNeedList.setText(null);
                //当前实际设置的频点
                // Current frequency range of settings
                int[] getFrqRange = null;
                getFrqRange = MyApp.getMyApp().getUhfMangerImpl().frequenceRange_Get();
                if (getFrqRange == null) {
                    setResult(false);
                    return;
                }
                for (int i = 0; i < getFrqRange.length; i++) {
                    if (i < getFrqRange.length - 1)
                        showNeedList.append(getFrqRange[i] + ",");
                    else
                        showNeedList.append(getFrqRange[i] + "");
                }
                setResult(true);
                break;
            case R.id.set_inv_mode:
                boolean flag = false;
                if (ifSupportR2000Fun)
                    flag = MyApp.getMyApp().getUhfMangerImpl().inventoryModelSet(invMode.getSelectedItemPosition(), save_inv_mode.isChecked());
                else
                    flag = MyApp.getMyApp().getUhfMangerImpl().inventoryModelSet(invMode.getSelectedItemPosition() == 0 ? 1 : 4, save_inv_mode.isChecked());
                setResult(flag);
                break;
            case R.id.get_inv_mode:
                int val = MyApp.getMyApp().getUhfMangerImpl().inventoryModelGet();
                boolean getInvResult = val >= 0 && val < 5;
                if (getInvResult) {
                    if (ifSupportR2000Fun)
                        invMode.setSelection(val);
                    else
                        invMode.setSelection(val == 1 ? 0 : 1);
                }
                setResult(getInvResult);
                break;
            default:
                break;

        }

    }


    private AlertDialog ad;
    //存放选中下标
    // Saving selected subscript
    private HashSet<Integer> hSet = new HashSet();
    //存放当前区域频率的所有频点
    // Saving of all frequencies in the current area
    private int[] getFrqRange = null;

    //设置需要的频点
    // set frequency range
    private void selectFrq() {
        getFrqRange = null;
        int area_fq = MyApp.getMyApp().getUhfMangerImpl().frequencyModeGetNotFixedFreq();
        if (ifSupportR2000Fun) {
            switch (area_fq) {
                case 0:
                    getFrqRange = cn_840;
                    break;
                case 1:
                    getFrqRange = cn_920;
                    break;
                case 2:
                    getFrqRange = eu;
                    break;
                case 3:
                    getFrqRange = us;
                    break;
                default:
                    break;
            }
        } else {
            //兼容UM2,UM1等模块
            // Compatible with UM2, UM1 modules
            getFrqRange = area_fq == 1 ? cn_920 : us;
        }
        if (getFrqRange != null) {
            hSet.clear();
            ad = new AlertDialog.Builder(getContext()).create();
            ad.setTitle(R.string.selected_fq_rang);
            GridView gd = new GridView(getContext());
            gd.setChoiceMode(AbsListView.CHOICE_MODE_MULTIPLE);
            gd.setNumColumns(3);
            Integer getFrqRanges[] = new Integer[getFrqRange.length];
            for (int i = 0; i < getFrqRange.length; i++) {
                getFrqRanges[i] = getFrqRange[i];
            }
            ArrayAdapter adapter = new ArrayAdapter(getContext(), android.R.layout.simple_list_item_single_choice, getFrqRanges);
            gd.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    CheckedTextView cb = view.findViewById(android.R.id.text1);
                    if (cb.isChecked()) {
                        hSet.add(position);
                    } else {
                        hSet.remove(position);
                    }
                }
            });
            gd.setAdapter(adapter);
            ad.setView(gd);
            ad.setButton(DialogInterface.BUTTON_POSITIVE, getString(R.string.determine), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    //实际选中的频点
                    //Actually selected frequency point
                    int[] frqSel = new int[hSet.size()];
                    int i = 0;
                    for (Integer integer : hSet) {
                        frqSel[i] = getFrqRange[integer];
                        i++;
                    }
                    boolean ifsuccess = MyApp.getMyApp().getUhfMangerImpl().frequenceRange_Set(frqSel.length, frqSel, false);
                    setResult(ifsuccess);
                }
            });
            ad.setButton(DialogInterface.BUTTON_NEGATIVE, getString(R.string.cancel), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    ad.dismiss();
                }
            });

            ad.create();
            ad.show();
        }
    }


    private void setResult(boolean flag) {
        if (flag) {
            MUtil.show(R.string.success);
        } else {
            MUtil.show(R.string.failed);
        }
    }

}
