/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans;

import com.rfid.trans.BaseReader;
import com.rfid.trans.ReaderParameter;
import com.rfid.trans.TagCallback;

public class UHFLib {
    private BaseReader reader = new BaseReader();
    private ReaderParameter param = new ReaderParameter();
    private volatile boolean mWorking = true;
    private volatile Thread mThread = null;
    private byte[] pOUcharIDList = new byte[25600];
    private volatile int NoCardCOunt = 0;

    public UHFLib() {
        this.param.ComAddr = (byte)-1;
        this.param.ScanTime = 2000;
        this.param.Session = 1;
        this.param.QValue = 4;
        this.param.TidLen = 0;
        this.param.TidPtr = 0;
        this.param.Antenna = 255;
    }

    public int Connect(String ComPort, int BaudRate) {
        int result = this.reader.Connect(ComPort, BaudRate, 1);
        if (result == 0) {
            byte[] Version = new byte[2];
            byte[] Power = new byte[1];
            byte[] band = new byte[1];
            byte[] MaxFre = new byte[1];
            byte[] MinFre = new byte[1];
            byte[] BeepEn = new byte[1];
            byte[] Ant = new byte[1];
            result = this.GetUHFInformation(Version, Power, band, MaxFre, MinFre, BeepEn, Ant);
        }
        return result;
    }

    public int DisConnect() {
        return this.reader.DisConnect();
    }

    public void SetInventoryPatameter(ReaderParameter param) {
        this.param = param;
    }

    public ReaderParameter GetInventoryPatameter() {
        return this.param;
    }

    public int GetUHFInformation(byte[] Version, byte[] Power, byte[] band, byte[] MaxFre, byte[] MinFre, byte[] BeepEn, byte[] Ant) {
        byte[] ReaderType = new byte[1];
        byte[] TrType = new byte[1];
        byte[] ScanTime = new byte[1];
        byte[] OutputRep = new byte[1];
        byte[] CheckAnt = new byte[1];
        byte[] ComAddr = new byte[]{-1};
        int result = this.reader.GetReaderInformation(ComAddr, Version, ReaderType, TrType, band, MaxFre, MinFre, Power, ScanTime, Ant, BeepEn, OutputRep, CheckAnt);
        if (result == 0) {
            this.param.ComAddr = ComAddr[0];
            this.param.Antenna = Ant[0];
        }
        return result;
    }

    public int SetRfPower(int Power) {
        return this.reader.SetRfPower(this.param.ComAddr, (byte)Power);
    }

    public int SetRegion(int band, int maxfre, int minfre) {
        return this.reader.SetRegion(this.param.ComAddr, band, maxfre, minfre);
    }

    public int SetAntenna(byte AntCfg) {
        byte SetOnce = 1;
        byte AntCfg1 = 0;
        int result = this.reader.SetAntennaMultiplexing(this.param.ComAddr, SetOnce, AntCfg1, AntCfg);
        if (result == 0) {
            this.param.Antenna = AntCfg;
        }
        return result;
    }

    public int SetBeepNotification(int BeepEn) {
        return this.reader.SetBeepNotification(this.param.ComAddr, (byte)BeepEn);
    }

    public String ReadDataByEPC(String EPCStr, byte Mem, byte WordPtr, byte Num, byte[] Password) {
        byte[] Errorcode;
        byte[] Data;
        byte MaskFlag;
        byte[] MaskData;
        byte MaskLen;
        byte[] MaskAdr;
        byte MaskMem;
        byte[] EPC;
        if (EPCStr.length() % 4 != 0) {
            return "FF";
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        int result = this.reader.ReadData_G2(this.param.ComAddr, ENum, EPC = this.reader.hexStringToBytes(EPCStr), Mem, WordPtr, Num, Password, MaskMem = 0, MaskAdr = new byte[2], MaskLen = 0, MaskData = new byte[12], MaskFlag = 0, Data = new byte[Num * 2], Errorcode = new byte[1]);
        if (result == 0) {
            return this.reader.bytesToHexString(Data, 0, Data.length);
        }
        return String.format("%2X", result);
    }

    public String ReadDataByTID(String TIDStr, byte Mem, byte WordPtr, byte Num, byte[] Password) {
        if (TIDStr.length() % 4 != 0) {
            return "FF";
        }
        byte ENum = -1;
        byte[] EPC = new byte[12];
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] Data = new byte[Num * 2];
        byte[] Errorcode = new byte[1];
        int result = this.reader.ReadData_G2(this.param.ComAddr, ENum, EPC, Mem, WordPtr, Num, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Data, Errorcode);
        if (result == 0) {
            return this.reader.bytesToHexString(Data, 0, Data.length);
        }
        return String.format("%2X", result);
    }

    public int WriteDataByEPC(String EPCStr, byte Mem, byte WordPtr, byte[] Password, String wdata) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (wdata.length() % 4 != 0) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte WNum = (byte)(wdata.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte MaskMem = 0;
        byte[] MaskAdr = new byte[2];
        byte MaskLen = 0;
        byte[] MaskData = new byte[12];
        byte MaskFlag = 0;
        byte[] Errorcode = new byte[1];
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Errorcode);
    }

    public int WriteDataByTID(String TIDStr, byte Mem, byte WordPtr, byte[] Password, String wdata) {
        if (TIDStr.length() % 4 != 0) {
            return 255;
        }
        if (wdata.length() % 4 != 0) {
            return 255;
        }
        byte ENum = -1;
        byte WNum = (byte)(wdata.length() / 4);
        byte[] EPC = new byte[12];
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] Errorcode = new byte[1];
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Errorcode);
    }

    public int WriteEPCByTID(String TIDStr, String EPCStr, byte[] Password) {
        if (TIDStr.length() % 4 != 0) {
            return 255;
        }
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        byte ENum = -1;
        byte WNum = (byte)(EPCStr.length() / 4);
        byte[] EPC = new byte[12];
        String PCStr = "";
        switch (WNum) {
            case 1: {
                PCStr = "0800";
                break;
            }
            case 2: {
                PCStr = "1000";
                break;
            }
            case 3: {
                PCStr = "1800";
                break;
            }
            case 4: {
                PCStr = "2000";
                break;
            }
            case 5: {
                PCStr = "2800";
                break;
            }
            case 6: {
                PCStr = "3000";
                break;
            }
            case 7: {
                PCStr = "3800";
                break;
            }
            case 8: {
                PCStr = "4000";
                break;
            }
            case 9: {
                PCStr = "4800";
                break;
            }
            case 10: {
                PCStr = "5000";
                break;
            }
            case 11: {
                PCStr = "5800";
                break;
            }
            case 12: {
                PCStr = "6000";
                break;
            }
            case 13: {
                PCStr = "6800";
                break;
            }
            case 14: {
                PCStr = "7000";
                break;
            }
            case 15: {
                PCStr = "7800";
                break;
            }
            case 16: {
                PCStr = "8000";
            }
        }
        String wdata = String.valueOf(PCStr) + EPCStr;
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] Errorcode = new byte[1];
        byte Mem = 1;
        byte WordPtr = 1;
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Errorcode);
    }

    public int Lock(String EPCStr, byte select, byte setprotect, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] Errorcode = new byte[1];
        return this.reader.Lock_G2(this.param.ComAddr, ENum, EPC, select, setprotect, Password, Errorcode);
    }

    public int Kill(String EPCStr, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] Errorcode = new byte[1];
        return this.reader.Kill_G2(this.param.ComAddr, ENum, EPC, Password, Errorcode);
    }

    public void SetCallBack(TagCallback callback) {
        this.reader.SetCallBack(callback);
    }

    public void StartRead() {
        if (this.mThread == null) {
            this.mWorking = true;
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte Target = 0;
                    while (UHFLib.this.mWorking) {
                        byte Ant = 1;
                        int antindex = 0;
                        while (antindex < 8) {
                            switch (antindex) {
                                case 0: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 1) != 1) break;
                                    Ant = -128;
                                    break;
                                }
                                case 1: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 2) != 2) break;
                                    Ant = -127;
                                    break;
                                }
                                case 2: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 4) != 4) break;
                                    Ant = -126;
                                    break;
                                }
                                case 3: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 8) != 8) break;
                                    Ant = -125;
                                    break;
                                }
                                case 4: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 0x10) != 16) break;
                                    Ant = -124;
                                    break;
                                }
                                case 5: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 0x20) != 32) break;
                                    Ant = -123;
                                    break;
                                }
                                case 6: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 0x40) != 64) break;
                                    Ant = -122;
                                    break;
                                }
                                case 7: {
                                    if ((((UHFLib)UHFLib.this).param.Antenna & 0x80) != 128) break;
                                    Ant = -121;
                                }
                            }
                            int[] pOUcharTagNum = new int[1];
                            int[] pListLen = new int[]{0};
                            pOUcharTagNum[0] = 0;
                            if (((UHFLib)UHFLib.this).param.Session == 0 || ((UHFLib)UHFLib.this).param.Session == 1) {
                                Target = 0;
                                UHFLib.this.NoCardCOunt = 0;
                            }
                            int result = UHFLib.this.reader.Inventory_G2(((UHFLib)UHFLib.this).param.ComAddr, (byte)((UHFLib)UHFLib.this).param.QValue, (byte)((UHFLib)UHFLib.this).param.Session, (byte)((UHFLib)UHFLib.this).param.TidPtr, (byte)((UHFLib)UHFLib.this).param.TidLen, Target, Ant, (byte)10, UHFLib.this.pOUcharIDList, pOUcharTagNum, pListLen);
                            if (pOUcharTagNum[0] == 0) {
                                if (((UHFLib)UHFLib.this).param.Session > 1) {
                                    UHFLib uHFLib = UHFLib.this;
                                    uHFLib.NoCardCOunt = uHFLib.NoCardCOunt + 1;
                                    if (UHFLib.this.NoCardCOunt > 7) {
                                        Target = (byte)(1 - Target);
                                        UHFLib.this.NoCardCOunt = 0;
                                    }
                                }
                            } else {
                                UHFLib.this.NoCardCOunt = 0;
                            }
                            ++antindex;
                        }
                    }
                }
            });
            this.mThread.start();
        }
    }

    public void StopRead() {
        if (this.mThread != null) {
            this.mWorking = false;
            this.mThread = null;
        }
    }
}

