/*
 * Decompiled with CFR 0.152.
 */
package com.example.iscandemo;

import android.content.Context;
import android.os.IScanListener;
import android.os.IScanListener2;
import com.idata.IDataManager;
import java.lang.reflect.Method;

public class iScanInterface {
    private IDataManager iDataManager;
    private Context mContext;

    public iScanInterface(Context context) {
        this.mContext = context;
        this.iDataManager = (IDataManager)this.mContext.getSystemService("idata");
    }

    public int getEngineType() {
        if (this.iDataManager != null) {
            return this.iDataManager.getEngineType();
        }
        return 0;
    }

    public void open() {
        if (this.iDataManager != null) {
            this.iDataManager.openScan();
        }
    }

    public void close() {
        if (this.iDataManager != null) {
            this.iDataManager.closeScan();
        }
    }

    public void scan_start() {
        if (this.iDataManager != null) {
            this.iDataManager.startScan();
        }
    }

    public void scan_stop() {
        if (this.iDataManager != null) {
            this.iDataManager.stopScan();
        }
    }

    public void lockScanKey(boolean enable) {
        this.iDataManager.SetBooleanValue("key_lock_Scankey", enable);
    }

    public void setOutputMode(int mode) {
        this.iDataManager.SetIntValue("key_broadcast", mode);
    }

    public void enablePlayBeep(boolean enable) {
        this.iDataManager.SetBooleanValue("key_beep", enable);
    }

    public void enableFailurePlayBeep(boolean enable) {
        this.iDataManager.SetBooleanValue("key_fail_beep", enable);
    }

    public void enablePlayVibrate(boolean enable) {
        this.iDataManager.SetBooleanValue("key_vibrate", enable);
    }

    public void lightSet(boolean enable) {
        this.iDataManager.SetBooleanValue("key_light", enable);
    }

    public void enableAddKeyValue(int value) {
        this.iDataManager.SetIntValue("key_terminator", value);
    }

    public void addPrefix(String text) {
        this.iDataManager.SetStringValue("key_prefix", text);
    }

    public void addSuffix(String text) {
        this.iDataManager.SetStringValue("key_suffix", text);
    }

    public void filterCharacter(String text) {
        this.iDataManager.SetStringValue("key_filter_character", text);
    }

    public void continuousScan(boolean enable) {
        this.iDataManager.SetBooleanValue("key_continus_scan", enable);
    }

    public void effortScan(boolean enable) {
        this.iDataManager.SetBooleanValue("key_effort", enable);
    }

    public void setTimeOut(int value) {
        this.iDataManager.SetIntValue("key_outtime", value);
    }

    public void setIntervalTime(int value) {
        this.iDataManager.SetIntValue("key_interval_time", value);
    }

    public void setEncodeFormart(int mode) {
        this.iDataManager.SetIntValue("key_charset", mode);
    }

    public void setDelete(boolean enable) {
        this.iDataManager.SetBooleanValue("key_deletect", enable);
    }

    public void resetScan() {
        this.iDataManager.resetScan();
    }

    public void setCenterMode(int mode) {
        this.iDataManager.SetIntValue("key_center_mode", mode);
    }

    public void setAimLightMode(int mode) {
        this.iDataManager.SetIntValue("key_aim_light", mode);
    }

    public void setMultiBarEnable(boolean enable) {
        this.iDataManager.SetBooleanValue("key_decode_multi_enable", enable);
    }

    public void setMultiBarPreciseStatus(boolean enable) {
        this.iDataManager.SetBooleanValue("key_decode_multy_exactlynbarcodes", enable);
    }

    public void setMultiBarNumber(int number) {
        this.iDataManager.SetIntValue("key_multi_number", number);
    }

    public void setEnableAimID(boolean enable) {
        this.iDataManager.SetBooleanValue("key_enable_aimid", enable);
    }

    public boolean getEnableAimID() {
        return this.iDataManager.GetBooleanValue("key_enable_aimid", false);
    }

    public void setBooleanValue(String keyid, boolean enable) {
        this.iDataManager.SetBooleanValue(keyid, enable);
    }

    public boolean getBooleanValue(String keyid) {
        return this.iDataManager.GetBooleanValue(keyid, false);
    }

    public void setBarcodeEnable(int barcodeId, boolean enable) {
        this.iDataManager.SetBarcodeStatus(barcodeId, enable);
    }

    public void setBatchReadingEnable(boolean enable) {
        this.iDataManager.SetBooleanValue("key_batch_reading", enable);
    }

    public void saveImageMode(int mode) {
        this.iDataManager.SetIntValue("key_save_image", mode);
    }

    public String getDecodeVersion() {
        return this.iDataManager.getDecodeVersion();
    }

    public void registerScan(IScanListener mIScanListener) {
        this.iDataManager.registerScanListener(mIScanListener);
    }

    public void unregisterScan(IScanListener mIScanListener) {
        this.iDataManager.unregisterScanListener(mIScanListener);
    }

    public void registerScan2(IScanListener2 mIScanListener) {
        this.iDataManager.registerScanListener2(mIScanListener);
    }

    public void unregisterScan2(IScanListener2 mIScanListener) {
        this.iDataManager.unregisterScanListener2(mIScanListener);
    }

    private void setProperty(String key, Boolean defaultValue) {
        Boolean value = defaultValue;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("set", String.class, Boolean.class);
            value = (Boolean)get.invoke(c, key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

