package com.uhf.uhfdemo;

import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;

import com.uhf.event.BackResult;
import com.uhf.event.BaseFragment;
import com.uhf.event.GetRFIDThread;
import com.uhf.util.DataAdapter;
import com.uhf.util.MLog;
import com.uhf.util.MUtil;
import com.uhf.util.ThreadUtil;
import com.uhf.base.UHFManager;
import com.uhf.base.UHFModuleType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.uhf.uhfdemo.MyApp.ifSupportR2000Fun;

public class LeftFragment extends BaseFragment implements View.OnClickListener, BackResult, AdapterView.OnItemSelectedListener {

    private LinearLayout invDataSet;
    private TextView read_RFID;
    private TextView tagNumbers, readNumbers, useTimes, epcShow, tidShow;
    private Spinner invtDataTypeSet;
    private View epc_tid_show_divd_Line;
    private String tagNumber, readNumber, takeTime;

    private long startTime, usTim, pauseTime;
    private DataAdapter mListAdapter;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        tagNumber = getString(R.string.tag_number) + ":";
        readNumber = getString(R.string.read_number) + ":";
        takeTime = getString(R.string.user_time) + ":";
        return inflater.inflate(R.layout.fragment_left, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initView(view);
    }

    private void initView(final View v) {
        read_RFID = v.findViewById(R.id.read_RFID);
        //清空数据
        // Clear data
        v.findViewById(R.id.clear_Data).setOnClickListener(this);
        ListView specific_Msg = v.findViewById(R.id.specific_Msg);

        tagNumbers = v.findViewById(R.id.tagNumbers);
        readNumbers = v.findViewById(R.id.readNumbers);
        useTimes = v.findViewById(R.id.useTimes);

        epcShow = v.findViewById(R.id.epcShow);
        tidShow = v.findViewById(R.id.tidShow);
        epc_tid_show_divd_Line = v.findViewById(R.id.epc_tid_show_divd_Line);
        invDataSet = v.findViewById(R.id.invDataSet);
        refreshUI();
        invtDataTypeSet = v.findViewById(R.id.invModSet);
        invtDataTypeSet.setOnItemSelectedListener(this);
        if (MyApp.currentInvtDataType > -1) {
            refreshTagDataTypeShow(MyApp.currentInvtDataType);
            invtDataTypeSet.setSelection(MyApp.currentInvtDataType);
        }

        read_RFID.setOnClickListener(this);
        read_RFID.setText(GetRFIDThread.getInstance().isIfPostMsg() ? R.string.stop_rfid : R.string.read_rfid);

        mListAdapter = new DataAdapter(getActivity(), realDataMap, realKeyList, tidList);
        specific_Msg.setAdapter(mListAdapter);
        GetRFIDThread.getInstance().setBackResult(this);
    }

    @Override
    public void refreshUI() {
        super.refreshUI();
        //是否为UM7的设备,或者是否为5100模块
        // Determining if it is a UM7 module , Or is it a 5100 module
        if (MyApp.getMyApp().getUhfMangerImpl().ifJ06() || !ifSupportR2000Fun || MyApp.if5100Module) {
            invDataSet.setVisibility(View.GONE);
        } else {
            invDataSet.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.read_RFID:
                startOrStopRFID();
                break;
            //清除显示数据
            // Clear data
            case R.id.clear_Data:
                if (GetRFIDThread.getInstance().isIfPostMsg()) {
                    MUtil.show(R.string.notice_clean_data);
                } else {
                    clearData();
                }
                break;
            default:
                break;
        }
    }

    private void clearData() {
        dataMap.clear();
        realDataMap.clear();
        realKeyList.clear();
        tidList.clear();
        usTim = pauseTime = 0;
        useTimes.setText(takeTime);
        tagNumbers.setText(tagNumber);
        readNumbers.setText(readNumber);
        mListAdapter.notifyDataSetChanged();
    }

    //开启或停止RFID模块
    // Start or Stop RFID
    public void startOrStopRFID() {
        boolean flag = !GetRFIDThread.getInstance().isIfPostMsg();
        invtDataTypeSet.setEnabled(!flag);
        if (flag) {
            if (UHFModuleType.SLR_MODULE == UHFManager.getType() && MyApp.if5100Module ){
                MyApp.getMyApp().getUhfMangerImpl().slrInventoryModeSet(0);
            }
            MyApp.getMyApp().getUhfMangerImpl().startInventoryTag();
            long tempTime = pauseTime;
            startTime = System.currentTimeMillis() - tempTime;
            ifSoundThreadAlive = true;
            playSound();
        } else {
            ifHaveTag = false;
            ifSoundThreadAlive = false;
            MyApp.getMyApp().getUhfMangerImpl().stopInventory();
        }
        GetRFIDThread.getInstance().setIfPostMsg(flag);
        read_RFID.setText(flag ? R.string.stop_rfid : R.string.read_rfid);
    }


    //识别的标签数据
    //The label's info what has been identified
    private Map<String, Integer> dataMap = new HashMap<>();

    private long postDataTime = 0;

    @Override
    public void postResult(String[] tagData) {
        //++rNumber;
        postDataTime = SystemClock.elapsedRealtime();
        ifHaveTag = true;
        //获取TID
        // get TID
        String tid = tagData[0];
        //拿到EPC
        // get EPC
        String epc = tagData[1];
        MLog.e("tid = " + tid + " epc = " + epc);
        //showDialog(epc);
        String filterData = MyApp.currentInvtDataType <= 0 ? epc : tid;
        //如果已存在，就拿到数量 ,note：因为EPC不唯一，又有客户把EPC弄成一样的，所以不能只以EPC区分
        // If it already exists, get the number
        Integer number = dataMap.get(/*epc*/filterData);
        if (number == null) {
            dataMap.put(/*epc*/filterData, 1);
            updateUI(epc, tid, 1);
        } else {
            int newNB = number + 1;
            dataMap.put(/*epc*/filterData, ++newNB);
            updateUI(epc, tid, newNB);
        }
    }

    @Override
    public void postInventoryRate(final long rate) {
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                // 张数/秒
                // tags per second
                readNumbers.setText(rate + readNumber);
            }
        });
    }

    @Override
    public void onKeyDown(int keyCode, KeyEvent event) {
        MLog.e("keyCode =" + keyCode);
        //把枪按钮被按下,默认值为F8,F4,BTN4
        //The trigger button is pressed, and the default value is F8,F4,BTN4
        if (keyCode == KeyEvent.KEYCODE_F8 || keyCode == KeyEvent.KEYCODE_F4 || keyCode == KeyEvent.KEYCODE_BUTTON_4) {
            startOrStopRFID();
        }
    }

    private Map<String, Integer> realDataMap = new HashMap<>();
    // realDataMap的key
    // realDataMap's key
    private List<String> realKeyList = new ArrayList<>();
    //tid info
    private List<String> tidList = new ArrayList<>();

    private void updateUI(final String epc, final String tid, final int readNumberss) {
        Objects.requireNonNull(getActivity()).runOnUiThread(new Runnable() {
            @Override
            public void run() {
                String filterData = MyApp.currentInvtDataType <= 0 ? epc : tid;
                if (readNumberss > 1) {
                    //修改数量
                    //Modified quantity
                    realDataMap.put(/*epc*/filterData, readNumberss);
                } else {
                    realDataMap.put(/*epc*/filterData, 1);
                    realKeyList.add(/*epc*/filterData);
                    tidList.add(MyApp.currentInvtDataType <= 0 ? tid : epc);
                }
                long endTime = System.currentTimeMillis();
                //盘点标签开始到结束的获取时间
                //Acquisition time from start to end of inventorying tag
                pauseTime = usTim = endTime - startTime;
                //花费的时间
                //Time spent
                useTimes.setText(takeTime + usTim);
                //标签数量
                //Number of tags
                tagNumbers.setText(tagNumber + realDataMap.size());
                mListAdapter.notifyDataSetChanged();
                long realUseTime = System.currentTimeMillis() - lastTime;
            /*    if (MyApp.ifOpenSound && realUseTime > 60) {
                    MyApp.getMyApp().playSound();
                    lastTime = endTime;
                }*/
            }
        });
    }

    private boolean ifSoundThreadAlive = true;
    private boolean ifHaveTag = false;
    private long lastTime;

    private void playSound() {
        ThreadUtil.getInstance().getExService().execute(new Runnable() {
            @Override
            public void run() {
                while (MyApp.ifOpenSound && ifSoundThreadAlive) {
                    if (ifHaveTag) {
                        //超过1s无数据暂停播放声音
                        //Pause playing sound without data for more than 1 s
                        if (lastTime != 0 && lastTime - postDataTime > 1000) {
                            ifHaveTag = false;
                            continue;
                        }
                        MyApp.getMyApp().playSound();
                        SystemClock.sleep(600);
                        lastTime = SystemClock.elapsedRealtime();
                    }
                }
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        ifHaveTag = false;
        ifSoundThreadAlive = false;
    }

    private void refreshTagDataTypeShow(int position) {
        clearData();
        epcShow.setVisibility(position == 1 ? View.GONE : View.VISIBLE);
        tidShow.setVisibility(position == 0 ? View.GONE : View.VISIBLE);
        epc_tid_show_divd_Line.setVisibility(position < 1 ? View.GONE : View.VISIBLE);
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        MyApp.currentInvtDataType = position;
        mListAdapter.setMode(position);
        refreshTagDataTypeShow(position);
        //OnlyTID+EPC,和EPC模式
        //OnlyTID+EPC,and EPC MODE
        position = Math.min(position, 1);
        MyApp.getMyApp().getUhfMangerImpl().readTagModeSet(position, false);
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {

    }
}
