package com.uhf.uhfdemo;

import android.Manifest;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;

import com.uhf.base.UHFManager;
import com.uhf.base.UHFModuleType;
import com.uhf.event.BaseFragment;
import com.uhf.event.GetRFIDThread;
import com.uhf.event.OnKeyDownListener;
import com.uhf.event.OnKeyListener;
import com.uhf.util.MLog;
import com.uhf.util.MUtil;
import com.uhf.util.ThreadUtil;

import java.util.Timer;
import java.util.TimerTask;

import realid.rfidlib.EmshConstant;

import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_BATTERY_ERROR;
import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_CHG_FULL;
import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_CHG_GENERAL;
import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_CHG_QUICK;
import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_DSG_UHF;
import static realid.rfidlib.EmshConstant.EmshBatteryPowerMode.EMSH_PWR_MODE_STANDBY;

public class MainActivity extends AppCompatActivity {

    private LeftFragment mLeftFragment;
    private RightFragment mRightFragment;
    private SearchFragment mSearchFragment;
    private FragmentManager manager;
    private ImageView toLeft, toRight, searchTag;

    private Object currentFragment;
    //RFID标签信息获取线程
    // RFID tag information acquisition thread
    private GetRFIDThread rfidThread = GetRFIDThread.getInstance();
    private Timer mTimer = null;
    private TimerTask mTimerTask = null;
    private boolean ifRequesetPermission = true;
    private boolean ifPowerOn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        supportRequestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_main);
        if (Build.VERSION.SDK_INT > 22)
            requestPermission();
        else
            init();
    }

    private void init() {
        toLeft = findViewById(R.id.toLeft);
        toRight = findViewById(R.id.toRight);
        searchTag = findViewById(R.id.searchTag);
        manager = getSupportFragmentManager();
        setCurrentPage(0);
        MUtil.showProgressDialog(getString(R.string.init_msg), this);
        rfidThread.start();
        ThreadUtil.getInstance().getExService().execute(new Runnable() {
            @Override
            public void run() {
                // 初始化开启把枪和串口配置(50把枪设备)
                // Initialisation of the device and serial port configuration （only 50 equipment）
                if (MyApp.getMyApp().getUhfMangerImpl().getDeviceInfo().isIfHaveTrigger()) {
                    ifPowerOn = MyApp.getMyApp().getUhfMangerImpl().powerOn();
                    MLog.e("powerOn = " + ifPowerOn);
                    MyApp.getMyApp().getUhfMangerImpl().changeConfig(true);
                    monitorEmsh();
                } else {
                    MLog.e("powerOn = " + MyApp.getMyApp().getUhfMangerImpl().powerOn());
                }
                getModuleInfo();
            }
        });
    }

    private void getModuleInfo() {
        //给时间(根据机型配置性能判断，一般2.5S足以)让串口和模块初始化
        //Give time (according to the configuration performance of the model, 2.5S is generally sufficient) for the serial port and module to initialize
        SystemClock.sleep(2500);
        if (UHFModuleType.UM_MODULE == UHFManager.getType()) {
            //初始化判断UM系列的UHF模块类型
            //Initialize and judge the UHF module type of UM series
            String ver = MyApp.getMyApp().getUhfMangerImpl().hardwareVerGet();
            if (!TextUtils.isEmpty(ver)) {
                //判断是否支持UM7模块功能
                //Determine whether the UM 7 module function is supported
                char moduleType = ver.charAt(0);
                MyApp.ifSupportR2000Fun = moduleType == '7' || moduleType == '4' || moduleType == '5';
                MLog.e("ifMode = " + MyApp.ifSupportR2000Fun + " ver =" + ver);
            }
            judgeModuleTypeAndRefreshUI(MyApp.ifSupportR2000Fun);
        } else if (UHFModuleType.SLR_MODULE == UHFManager.getType()) {
            String type = MyApp.getMyApp().getUhfMangerImpl().getUHFModuleType();
            MLog.e("type = " + type);
            if (!TextUtils.isEmpty(type)) {
                if (type.contains("5100")) {
                    MyApp.if5100Module = true;
                    judgeModuleTypeAndRefreshUI(false);
                }
            }
            MUtil.cancleDialog();
        }
    }


    private void judgeModuleTypeAndRefreshUI(final boolean isShowSearchPage) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                searchTag.setVisibility(isShowSearchPage ? View.VISIBLE : View.GONE);
                MUtil.cancleDialog();
                if (currentFragment != null && currentFragment instanceof BaseFragment) {
                    ((BaseFragment) currentFragment).refreshUI();
                }
            }
        });
    }

    private final int requestPermissionCode = 10;

    private void requestPermission() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (checkSelfPermission(Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED ||
                    checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.READ_EXTERNAL_STORAGE}, requestPermissionCode);
            } else {
                ifRequesetPermission = false;
                init();
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == requestPermissionCode) {
            if (grantResults[0] != PackageManager.PERMISSION_GRANTED) {
                recyleResoure();
            } else {
                ifRequesetPermission = false;
                init();
            }
        }
    }

    //定时监听把枪状态
    // Listening for device status at regular intervals
    private void monitorEmsh() {
        mEmshStatusReceiver = new EmshStatusBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter(EmshConstant.Action.INTENT_EMSH_BROADCAST);
        registerReceiver(mEmshStatusReceiver, intentFilter);

        mTimer = new Timer();
        mTimerTask = new TimerTask() {
            @Override
            public void run() {
                Intent intent = new Intent(EmshConstant.Action.INTENT_EMSH_REQUEST);
                intent.putExtra(EmshConstant.IntentExtra.EXTRA_COMMAND, EmshConstant.Command.CMD_REFRESH_EMSH_STATUS);
                sendBroadcast(intent);
            }
        };
        mTimer.schedule(mTimerTask, 0, 1000);
    }

    //设置当前显示的页面
    // Set the currently displayed page
    private void setCurrentPage(int tabPage) {
        FragmentTransaction transaction = manager.beginTransaction();
        switch (tabPage) {
            //主界面
            // Main screen
            case 0:
                currentFragment = mLeftFragment = (mLeftFragment == null ? new LeftFragment() : mLeftFragment);
                break;
            //设置界面
            // Setting screen    
            case 1:
                currentFragment = mRightFragment = (mRightFragment == null ? new RightFragment() : mRightFragment);
                break;
            //标签查找界面
            // Tag finder screen
            case 2:
                currentFragment = mSearchFragment = (mSearchFragment == null ? new SearchFragment() : mSearchFragment);
                break;
            default:
                break;
        }
        transaction.replace(R.id.showData, (Fragment) currentFragment);
        transaction.commit();
    }

    private int[] pageId = {R.id.toLeft, R.id.toRight, R.id.searchTag};

    public void onClick(View v) {
        for (int i = 0; i < pageId.length; i++) {
            if (pageId[i] == v.getId()) {
                if (GetRFIDThread.getInstance().isIfPostMsg()) {
                    MUtil.show(R.string.notice_close_inventroy);
                    return;
                }
                setCurrentPage(i);
                toLeft.setImageResource(pageId[i] == R.id.toLeft ? R.drawable.main_click : R.drawable.main_noclick);
                toRight.setImageResource(pageId[i] == R.id.toRight ? R.drawable.set_click : R.drawable.set_noclick);
                searchTag.setImageResource(pageId[i] == R.id.searchTag ? R.drawable.search_clcik : R.drawable.search_noclcik);
                break;
            }
        }
    }

    //手柄按钮控制RFID线程读取与停止
    // Handle button controls RFID thread reading and stopping
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (currentFragment instanceof OnKeyDownListener) {
            ((OnKeyDownListener) currentFragment).onKeyDown(keyCode, event);
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (currentFragment instanceof OnKeyListener) {
            ((OnKeyListener) currentFragment).onKeyUp(keyCode, event);
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    protected void onResume() {
        super.onResume();
        switchTriggerMode(false);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (!ifRequesetPermission) {
            recyleResoure();
        }
        switchTriggerMode(true);
    }

    /**
     * 开关把枪触发iScan扫描的功能
     */
    private void switchTriggerMode(boolean flag) {
        Intent switchIScanKey = new Intent("android.intent.action.UHF_CHECK_TRIGGER");
        switchIScanKey.putExtra("isEnableScan", flag);
        sendBroadcast(switchIScanKey);
    }

    private volatile long lastTime = 0;

    @Override
    public void onBackPressed() {
        long currentTime = SystemClock.currentThreadTimeMillis();
        if (lastTime != 0 && currentTime - lastTime < 500) {
            recyleResoure();
        } else {
            MUtil.show(R.string.exit_app);
        }
        lastTime = currentTime;
    }

    //下电，回收停止线程，退出应用
    // Power down, recycle stop threads, exit application
    private void recyleResoure() {
        //这里强制停止盘点，无论是否使用
        // Forced cessation of inventory, whether used or not
        MyApp.getMyApp().getUhfMangerImpl().stopInventory();
        switchTriggerMode(true);
        if (mEmshStatusReceiver != null) {
            unregisterReceiver(mEmshStatusReceiver);
            mEmshStatusReceiver = null;
        }
        if (mTimer != null || mTimerTask != null) {
            mTimerTask.cancel();
            mTimer.cancel();
            mTimerTask = null;
            mTimer = null;
        }
        rfidThread.destoryThread();
        MLog.e("powoff = " + MyApp.getMyApp().getUhfMangerImpl().powerOff());
        MyApp.getMyApp().getUhfMangerImpl().changeConfig(false);
        System.exit(0);
    }

    private EmshStatusBroadcastReceiver mEmshStatusReceiver;

    private int oldStatue = -1;

    public class EmshStatusBroadcastReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {

            if (EmshConstant.Action.INTENT_EMSH_BROADCAST.equalsIgnoreCase(intent.getAction())) {

                int sessionStatus = intent.getIntExtra("SessionStatus", 0);
                int batteryPowerMode = intent.getIntExtra("BatteryPowerMode", -1);
                //  MLog.e("sessionStatus = " + sessionStatus + "  batteryPowerMode  = " + batteryPowerMode);
                // 把枪电池当前状态
                // Current status of battery
                if ((sessionStatus & EmshConstant.EmshSessionStatus.EMSH_STATUS_POWER_STATUS) != 0) {
                    //相同状态不处理
                    // Same status does not process
                    if (batteryPowerMode == oldStatue) {
                        MUtil.cancelWaringDialog();
                        return;
                    }
                    oldStatue = batteryPowerMode;
                    switch (batteryPowerMode) {
                        case EMSH_PWR_MODE_STANDBY:
                            MLog.e("standby status");
                            if (!ifPowerOn) {
                                MyApp.getMyApp().getUhfMangerImpl().powerOn();
                                getModuleInfo();
                            }
                            ifPowerOn = false;
                            break;
                        case EMSH_PWR_MODE_DSG_UHF:
                            MLog.e("DSG_UHF status");
                            MUtil.show(R.string.poweron_success);
                            break;
                        case EMSH_PWR_MODE_CHG_GENERAL:
                        case EMSH_PWR_MODE_CHG_QUICK:
                            MLog.e("charging status");
                            MUtil.show(R.string.charing);
                            break;
                        case EMSH_PWR_MODE_CHG_FULL:
                            MLog.e("charging full status");
                            MUtil.show(R.string.charing_full);
                            break;
                        default:
                            break;
                    }
                } else {
                    oldStatue = EMSH_PWR_MODE_BATTERY_ERROR;
                    MLog.e("unknown status");
                    MUtil.warningDialog(MainActivity.this);
                }
            }
        }
    }


}
