package com.uhf.setting;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;

import com.uhf.event.BaseFragment;
import com.uhf.uhfdemo.MyApp;
import com.uhf.uhfdemo.R;
import com.uhf.util.MUtil;

import static android.text.TextUtils.isEmpty;

public class ReadOrWriteTagFragment extends BaseFragment implements View.OnClickListener {

    private Spinner spFilterMbWr, spMbWr;
    private EditText EtFilterAdsTagWr, EtFilterlenTagWr, EtFilterDataTagWr, EtAdsTagWr, EtLenTagWr, EtDataTagWr, EtPwdTagWr;
    private CheckBox CBFilterWr;
    private String[] spirw = {"RFU", "EPC", "TID", "USR"};

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_write_tag, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initView(view);
    }

    private void initView(View v) {
        View tops = v.findViewById(R.id.wTop);
        View bottoms = v.findViewById(R.id.wBottom);
        //过滤部分
        // Filter
        spFilterMbWr = tops.findViewById(R.id.spinner_MB);
        EtFilterAdsTagWr = tops.findViewById(R.id.Et_set_ads);
        EtFilterlenTagWr = tops.findViewById(R.id.Et_Set_len);
        EtFilterDataTagWr = tops.findViewById(R.id.Et_Set_data);

        spFilterMbWr.setSelection(0);
        CBFilterWr = v.findViewById(R.id.CB_FlWr);

        //标签过滤操作，EPC开始位置（Bit）
        // Tag filtering, EPC start position (Bit)
        EtFilterAdsTagWr.setText("32");
        //标签过滤操作，EPC长度(Bit)
        // Tag filtering, EPC length (Bit)
        EtFilterlenTagWr.setText("96");
        //标签过滤操作，ECP数据（16进制）
        // Tag filtering, ECP data (hexadecimal)
        EtFilterDataTagWr.setText("1234567890ABCDEF12345678");

        //读写部分
        // Reading and writing
        LinearLayout acs_pswd = bottoms.findViewById(R.id.acs_pswd);
        //显示隐藏的acces password的布局
        // Show the layout of the access password
        acs_pswd.setVisibility(View.VISIBLE);

        spMbWr = bottoms.findViewById(R.id.spinner_MB);
        ArrayAdapter<String> arradp_rw = new ArrayAdapter<String>(getActivity(),
                android.R.layout.simple_spinner_item, spirw);
        arradp_rw.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spMbWr.setAdapter(arradp_rw);

        //设置选中EPC
        // Set selected EPC
        spMbWr.setSelection(1);

        EtAdsTagWr = bottoms.findViewById(R.id.Et_set_ads);
        EtLenTagWr = bottoms.findViewById(R.id.Et_Set_len);
        EtPwdTagWr = bottoms.findViewById(R.id.Et_AcPwdRead);
        EtDataTagWr = bottoms.findViewById(R.id.Et_Set_data);

        v.findViewById(R.id.Bt_Wr).setOnClickListener(this);
        v.findViewById(R.id.Bt_Rd).setOnClickListener(this);

        //读写EPC操作，密码（16进制）
        // Reading and writing the EPC, Password (hexadecimal)
        EtPwdTagWr.setText("00000000");
        //读写EPC操作，EPC开始位置(WORD类型)
        // Reading and writing the EPC, EPC start position (WORD type)
        EtAdsTagWr.setText("2");
        //读写EPC操作，EPC长度(WORD类型)
        // Reading and writing the EPC, EPC length (WORD type)
        EtLenTagWr.setText("6");
        // 读写操作，ECP数据（16进制）
        // Reading and writing the EPC, ECP data (hexadecimal)
        EtDataTagWr.setText("1234567890ABCDEF12345678");
    }

    @Override
    public void onClick(View v) {
        if (!ifNotNull()) {
            MUtil.show(R.string.data_notnull);
            return;
        }
        //true 则点击的是写入按钮，false 则是读取按钮
        // true is the write button, false is the read button
        boolean ifWrite = (v.getId() == R.id.Bt_Wr);
        boolean status = false;
        String result = null;
        boolean ifChecked = CBFilterWr.isChecked();
        int Flindex = spFilterMbWr.getSelectedItemPosition() + 1;
        String PwdWr = EtPwdTagWr.getText().toString();
        int Flads = Integer.valueOf(EtFilterAdsTagWr.getText().toString());
        int Fllen = Integer.valueOf(EtFilterlenTagWr.getText().toString());
        String Fldata = EtFilterDataTagWr.getText().toString();
        int MbWr = spMbWr.getSelectedItemPosition();
        int ads = Integer.valueOf(EtAdsTagWr.getText().toString());
        int len = Integer.valueOf(EtLenTagWr.getText().toString());
        String data = EtDataTagWr.getText().toString();

        //启用过滤
        // Enable filtering
        if (ifChecked) {
            //写操作
            // Writing
            if (ifWrite) {
                status = MyApp.getMyApp().getUhfMangerImpl().writeTag(PwdWr, Flindex, Flads, Fllen, Fldata, MbWr, ads, len, data);
            } else {
                result = MyApp.getMyApp().getUhfMangerImpl().readTag(PwdWr, Flindex, Flads, Fllen, Fldata, MbWr, ads, len);
            }
        }
        //不启用过滤
        // Disable filtering
        else {
            if (ifWrite) {
                if (1 == MbWr) {
                    status = MyApp.getMyApp().getUhfMangerImpl().writeDataToEpc(PwdWr, ads, len, data);
                } else {
                    status = MyApp.getMyApp().getUhfMangerImpl().writeTag(PwdWr, 0, 0, 0, "0", MbWr, ads, len, data);
                }
            } else {
                result = MyApp.getMyApp().getUhfMangerImpl().readTag(PwdWr, 0, 0, 0, "0", MbWr, ads, len);
            }
        }
        String readSuccess = getString(R.string.read_success);
        String showText = ifWrite ? (status ? getString(R.string.write_success) : getString(R.string.write_failed)) : (result == null ? getString(R.string.read_failed) : readSuccess);
        MUtil.show(showText);
        if (showText.equals(readSuccess)) {
            //显示读取成功的数据
            // Shows data read successfully
            EtDataTagWr.setText(result);
        }
    }

    private boolean ifNotNull() {
        return !isEmpty(EtFilterAdsTagWr.getText()) && !isEmpty(EtFilterlenTagWr.getText()) && !isEmpty(EtFilterDataTagWr.getText()) &&
                !isEmpty(EtAdsTagWr.getText()) && !isEmpty(EtLenTagWr.getText()) && !isEmpty(EtDataTagWr.getText()) && !isEmpty(EtPwdTagWr.getText());
    }

}

