package com.uhf.setting;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Spinner;

import com.uhf.event.BaseFragment;
import com.uhf.uhfdemo.MyApp;
import com.uhf.uhfdemo.R;
import com.uhf.util.MUtil;

import static android.text.TextUtils.isEmpty;

public class LockTagFragment extends BaseFragment implements View.OnClickListener {

    private Spinner spFilterMbLock;
    private EditText EtFilterAdsLock, EtFilterLenLock, EtFilterDataLock;

    private Spinner spLock;
    private EditText EtAcPwdLock;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_lock_tag, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View v, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(v, savedInstanceState);
        View top = v.findViewById(R.id.lockTop);

        spLock = v.findViewById(R.id.sp_Lock);
        spFilterMbLock = top.findViewById(R.id.spinner_MB);

        EtFilterAdsLock = top.findViewById(R.id.Et_set_ads);
        EtFilterLenLock = top.findViewById(R.id.Et_Set_len);
        EtFilterDataLock = top.findViewById(R.id.Et_Set_data);

        EtAcPwdLock = v.findViewById(R.id.Et_AcPwdLock);
        v.findViewById(R.id.Bt_Lock).setOnClickListener(this);
        v.findViewById(R.id.Bt_unLock).setOnClickListener(this);

        EtAcPwdLock.setText("00000000");
        EtFilterAdsLock.setText("32");
        EtFilterLenLock.setText("96");
        EtFilterDataLock.setText("1234567890ABCDEF12345678");
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.Bt_Lock:
                //锁标签
                // lock
                lock(true);
                break;
            case R.id.Bt_unLock:
                //解锁标签
                // unlock
                lock(false);
                break;
            default:
                break;
        }
    }


    private void lock(boolean flag) {
        if (ifNotNull()) {
            int ads = Integer.valueOf(EtFilterAdsLock.getText().toString());
            int len = Integer.valueOf(EtFilterLenLock.getText().toString());
            int lockitem = spLock.getSelectedItemPosition() + 1;
            int val = spFilterMbLock.getSelectedItemPosition();
            boolean status = false;
            if (flag) {
                //具体的锁标签操作
                // lock
                status = MyApp.getMyApp().getUhfMangerImpl().lockMen(EtAcPwdLock.getText().toString(), MyApp.UHF[val],
                        ads, len, EtFilterDataLock.getText().toString(), lockitem);
            } else {
                //具体的锁标签操作
                // unlock
                status = MyApp.getMyApp().getUhfMangerImpl().unlockMen(EtAcPwdLock.getText().toString(), MyApp.UHF[val],
                        ads, len, EtFilterDataLock.getText().toString(), lockitem);
            }
            int str = status ? (flag ? R.string.lock_success : R.string.unlock_success) : (flag ? R.string.lock_failed : R.string.unlock_failed);
            MUtil.show(str);
        } else {
            MUtil.show(R.string.data_notnull);
        }

    }

    private boolean ifNotNull() {
        return !isEmpty(EtFilterAdsLock.getText()) && !isEmpty(EtFilterLenLock.getText())
                && !isEmpty(EtFilterDataLock.getText()) && !isEmpty(EtAcPwdLock.getText());
    }

}
