package com.uhf.util;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.uhf.uhfdemo.R;

import java.util.List;
import java.util.Map;

/**
 * author CYD
 * date 2018/11/21
 *
 */
public class DataAdapter extends BaseAdapter {

    private Context con;
    private Map<String, Integer> realDataMap;
    private List<String> realKeyList, tidList;
    private int mode = 0;

    public DataAdapter(Context con, Map<String, Integer> realDataMap, List<String> realKeyList, List<String> tidList) {
        this.con = con;
        this.realDataMap = realDataMap;
        this.realKeyList = realKeyList;
        this.tidList = tidList;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getCount() {
        return realKeyList.size();
    }

    @Override
    public Object getItem(int position) {
        return realKeyList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View v, ViewGroup parent) {
        ViewHolder vh;
        if (v == null) {
            v = LayoutInflater.from(con).inflate(R.layout.item, null);
            vh = new ViewHolder();
            vh.epc = v.findViewById(R.id.epc);
            vh.tid = v.findViewById(R.id.tid);
            vh.epc_tid_divd_Line = v.findViewById(R.id.epc_tid_divd_Line);
            vh.count = v.findViewById(R.id.count);
            vh.sn = v.findViewById(R.id.sn);
            v.setTag(vh);
        } else {
            vh = (ViewHolder) v.getTag();
        }
        vh.epc.setVisibility(mode == 1 ? View.GONE : View.VISIBLE);
        vh.tid.setVisibility(mode == 0 ? View.GONE : View.VISIBLE);
        vh.epc_tid_divd_Line.setVisibility(mode < 1 ? View.GONE : View.VISIBLE);
        boolean ifOnlyEPC = mode <= 0;
        String epc, tid;
        String data = realKeyList.get(position);
        String data1 = tidList.get(position);

        epc = ifOnlyEPC ? data : data1;
        tid = ifOnlyEPC ? data1 : data;
        String readNumber = String.valueOf(realDataMap.get(ifOnlyEPC ? epc : tid));
        vh.sn.setText((position + 1) + "");
        vh.epc.setText(epc);
        vh.tid.setText(tid);
        vh.count.setText(readNumber);
        return v;
    }


    private class ViewHolder {
        private TextView sn, epc, tid, count;
        private View epc_tid_divd_Line;
    }
}
